@extends($activeTemplate. 'layouts.frontend')
@section('content')
<div class="section--sm pricing-section">
    <div class="container-xl">
        <div class="row g-3 justify-content-center">
            @foreach($plans as $plan)
                <div class="col-sm-6 col-lg-3">
                    <div class="pricing {{ $plan->highlight == 1 ? 'pricing--popular' : '' }}">
                        @if($plan->highlight == 1)
                            <span class="pricing__tag">@lang('Popular')</span>
                        @endif
                        <div class="pricing__head">
                            <h4 class="pricing__title">{{ __($plan->name) }}</h4>
                            <span class="pricing__sub-title">
								{{ __($plan->tagline) }}
							</span>
                        </div>
                        <div class="pricing__plan">
                            <div class="pricing__plan-container">
                                <div class="pricing__price">
                                    <span class="pricing__currency">
                                        <i class="las la-dollar-sign"></i>
                                    </span>
                                    <h1 class="pricing__amount">
                                        {{ __(showAmount($plan->price)) }}
                                    </h1>
                                </div>
                                <span class="pricing__text">{{$general->cur_text}}</span>
                            </div>


                            @if (@auth()->user()->runningPlan && @auth()->user()->plan_id == $plan->id)
                                <button class="pricing__btn disabled">@lang('Current Package')</button>
                            @else
                                <button class="pricing__btn {{ $plan->highlight == 1 ? 'pricing__btn-popular' : 'pricing__btn-regular' }} buyBtn" data-id="{{ $plan->id }}">
                                    @lang('Subscribe Now')
                                </button>
                            @endif
                             
                        </div>
                        <div class="pricing__body">
                            <ul class="list pricing__list">
                                <li class="pricing__item pricing__item-success">
                                    @lang('Daily Limit') : {{ $plan->daily_limit }} @lang('PTC')
                                </li>
                                <li class="pricing__item pricing__item-success">
                                    @lang('Referral Bonus') : @lang('Upto') {{ $plan->ref_level }} @lang('Level')
                                </li>
                                <li class="pricing__item pricing__item-success">
                                    @lang('Plan Price') : {{ showAmount($plan->price) }} {{ __($general->cur_text) }}
                                </li>
                                <li class="pricing__item pricing__item-success">
                                    @lang('Validity') : {{ $plan->validity }} @lang('Days')
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>

    <div class="modal custom--modal fade" id="BuyModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <form method="post" action="{{ route('user.buyPlan') }}">
                    @csrf
                    <input type="hidden" name="id">
                    <div class="modal-header">
                        <strong class="modal-title"> @lang('Confirmation')</strong>

                        <button type="button" class="close btn btn-sm btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        @auth
                        <p>@lang('Are you sure to subscribe this plan?')</p>
                            @if(auth()->user()->runningPlan)
                            <code class="d-block">@lang('If you subscribe to this one. Your old limitation will reset according to this package.')</code>
                            @endif
                        @else
                        <p>@lang('Please login to subscribe plan')</p>
                        @endauth
                    </div>
                    <div class="modal-footer">
                        @auth
                            <button type="button" class="btn btn-dark" data-bs-dismiss="modal">@lang('No')</button>
                            <button type="submit" class="btn btn--base">@lang('Yes')</button>
                        @else
                            <a href="{{ route('user.login') }}" class="btn btn--base w-100">@lang('Login')</a>
                        @endauth
                    </div>

                </form>

            </div>
        </div>
    </div>

</div>

    @if($sections->secs != null)
        @foreach(json_decode($sections->secs) as $sec)
            @include($activeTemplate.'sections.'.$sec)
        @endforeach
    @endif

@endsection
@push('style')
    <style>
        .package-disabled {
            opacity: 0.5;
        }
    </style>
@endpush
@push('script')
    <script type="text/javascript">
        (function($) {
            "use strict";
            $('.buyBtn').click(function() {
                var modal = $('#BuyModal');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.modal('show');
            });
        })(jQuery);
    </script>
@endpush