@php
    $planCaption = getContent('plan.content',true);
    $plans = App\Models\Plan::where('status',1)->get();
@endphp
<div class="section--sm pricing-section">
    <div class="section__head">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-xl-6">
                    <div class="text-center">
                        <span class="section__subtitle">
                            {{ __(@$planCaption->data_values->subheading) }}
                        </span>
                        <h2 class="section__title m-0">
                            {{ __(@$planCaption->data_values->heading) }}
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-xl">
        <div class="row g-3 justify-content-center">
            @foreach($plans as $plan)
                <div class="col-sm-6 col-lg-3">
                    <div class="pricing {{ $plan->highlight == 1 ? 'pricing--popular' : '' }}">
                        @if($plan->highlight == 1)
                            <span class="pricing__tag">@lang('Popular')</span>
                        @endif
                        <div class="pricing__head">
                            <h4 class="pricing__title">{{ __($plan->name) }}</h4>
                            <span class="pricing__sub-title">
								{{ __($plan->tagline) }}
							</span>
                        </div>
                        <div class="pricing__plan">
                            <div class="pricing__plan-container">
                                <div class="pricing__price">
                                    <h1 class="pricing__amount">
                                        {{ __(getAmount($plan->price)) }}
                                    </h1>
                                </div>
                                <span class="pricing__text">{{$general->cur_text}}</span>
                            </div>
                            
                            @if (@auth()->user()->runningPlan && @auth()->user()->plan_id == $plan->id)
                                <button class="pricing__btn disabled">@lang('Current Package')</button>
                            @else
                                <button class="pricing__btn {{ $plan->highlight == 1 ? 'pricing__btn-popular' : 'pricing__btn-regular' }} buyBtn" data-id="{{ $plan->id }}">
                                    @lang('Subscribe Now')
                                </button>
                            @endif
                             
                        </div>
                        <div class="pricing__body">
                            <ul class="list pricing__list">
                                <li class="pricing__item pricing__item-success">
                                    @lang('Daily Limit') : {{ $plan->daily_limit }} @lang('PTC')
                                </li>
                                <li class="pricing__item pricing__item-success">
                                    @lang('Referral Bonus') : @lang('Upto') {{ $plan->ref_level }} @lang('Level')
                                </li>
                                <li class="pricing__item pricing__item-success">
                                    @lang('Plan Price') : {{ showAmount($plan->price) }} {{ __($general->cur_text) }}
                                </li>
                                <li class="pricing__item pricing__item-success">
                                    @lang('Validity') : {{ $plan->validity }} @lang('Days')
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>

<div class="modal custom--modal fade" id="BuyModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <form method="post" action="{{ route('user.buyPlan') }}">
                @csrf
                <input type="hidden" name="id">
                <div class="modal-header">
                    <strong class="modal-title"> @lang('Confirmation')</strong>
                    <button type="button" class="close btn btn-sm btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    @auth
                    <p>@lang('Are you sure to subscribe this plan?')</p>
                    @if(auth()->user()->runningPlan)
                        <code class="d-block">@lang('If you subscribe to this one. Your old limitation will reset according to this package.')</code>
                    @endif
                    @else
                    <p>@lang('Please login to subscribe plan')</p>
                    @endauth
                </div>
                <div class="modal-footer">
                    @auth
                    <button type="button" class="btn btn-dark" data-bs-dismiss="modal">@lang('No')</button>
                    <button type="submit" class="btn btn--base rounded">@lang('Yes')</button>
                    @else
                    <a href="{{ route('user.login') }}" class="btn btn--base rounded">@lang('Login')</a>
                    @endauth
                </div>

            </form>

        </div>
    </div>
</div>
@push('script')
<script type="text/javascript">
    (function($){
        "use strict";
        $('.buyBtn').click(function(){
            var modal = $('#BuyModal');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.modal('show');
        });
    })(jQuery);
</script>
@endpush